<?php
// Get the JSON payload
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// Database connection
$servername = "localhost";
$username = "cloudrain_HardwareInfoDB";
$password = "PjvqTS}BUkB)";
$dbname = "cloudrain_HardwareInfoDB";


try {
    
    // Create a new PDO instance
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Get the JSON input
    $input = json_decode(file_get_contents('php://input'), true);

    // Log incoming data for debugging
    file_put_contents('debug.log', print_r($input, true), FILE_APPEND);

    // Check if antivirus details are provided
    if (isset($input) && is_array($input)) {
        // Prepare SQL statement to insert/update antivirus details
foreach ($input as $antivirus) {
    // Check if PathToExecutable and Version are not empty or null
    $antivirus['PathToExecutable'] = !empty($antivirus['PathToExecutable']) ? $antivirus['PathToExecutable'] : 'N/A';
    $antivirus['Version'] = !empty($antivirus['Version']) ? $antivirus['Version'] : 'N/A';

    $stmt = $pdo->prepare("
        INSERT INTO AntivirusDetails (ComputerName, ProductName, ProductState, PathToExecutable, Version, InstanceGuid, Timestamp, logged_in_user, domain) 
        VALUES (:ComputerName, :ProductName, :ProductState, :PathToExecutable, :Version, :InstanceGuid, :Timestamp, :logged_in_user, :domain)
        ON DUPLICATE KEY UPDATE 
            ProductState = :ProductState, 
            PathToExecutable = :PathToExecutable,
            Version = :Version,
            Timestamp = :Timestamp,
            logged_in_user = :logged_in_user,
            domain = :domain
            
    ");

    // Bind parameters
    $stmt->bindParam(':ComputerName', $antivirus['ComputerName']);
    $stmt->bindParam(':ProductName', $antivirus['ProductName']);
    $stmt->bindParam(':ProductState', $antivirus['ProductState']);
    $stmt->bindParam(':PathToExecutable', $antivirus['PathToExecutable']);
    $stmt->bindParam(':Version', $antivirus['Version']);
    $stmt->bindParam(':InstanceGuid', $antivirus['InstanceGuid']);
    $stmt->bindParam(':Timestamp', $antivirus['Timestamp']);
    $stmt->bindParam(':logged_in_user', $antivirus['logged_in_user']);
    $stmt->bindParam(':domain', $antivirus['domain']);


    // Execute the statement
    $stmt->execute();
}



        echo json_encode(['Antivirus details updated successfully']);
    } else {
        echo json_encode(['No antivirus details provided']);
    }
} catch (PDOException $e) {
    // Log the error message
    file_put_contents('debug.log', 'Error: ' . $e->getMessage(), FILE_APPEND);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
