<?php
// Include the database configuration file
require 'dbconfig.php';

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get the POST data
$hostName = $_POST['HostName'];
$os = $_POST['OS'];
$osVersion = $_POST['OSVersion'];
$manufacturer = $_POST['Manufacturer'];
$model = $_POST['Model'];
$totalMemoryGB = $_POST['TotalMemoryGB'];
$cpu = $_POST['CPU'];
$cpuSockets = $_POST['CPUSockets'];
$cpuCores = $_POST['CPUCores'];
$hyperVState = $_POST['HyperVState'];
$vmDetails = json_decode($_POST['VMDetails'], true); // Decode the JSON for VM details

// Check if the host already exists
$sqlCheckHost = "SELECT HostID FROM HostDetails WHERE HostName = ?";
$stmtCheckHost = $conn->prepare($sqlCheckHost);
$stmtCheckHost->bind_param("s", $hostName);
$stmtCheckHost->execute();
$stmtCheckHost->store_result();

// If host exists, update the details, otherwise insert new
if ($stmtCheckHost->num_rows > 0) {
    // Host exists, update the record
    $stmtCheckHost->bind_result($hostID);
    $stmtCheckHost->fetch();

    $sqlUpdateHost = "UPDATE HostDetails SET OS = ?, OSVersion = ?, Manufacturer = ?, Model = ?, TotalMemoryGB = ?, CPU = ?, CPUSockets = ?, CPUCores = ?, HyperVState = ? WHERE HostID = ?";
    $stmtUpdateHost = $conn->prepare($sqlUpdateHost);
    $stmtUpdateHost->bind_param("ssssdiissi", $os, $osVersion, $manufacturer, $model, $totalMemoryGB, $cpu, $cpuSockets, $cpuCores, $hyperVState, $hostID);
    $stmtUpdateHost->execute();
    $stmtUpdateHost->close();
} else {
    // Host does not exist, insert a new record
    $sqlInsertHost = "INSERT INTO HostDetails (HostName, OS, OSVersion, Manufacturer, Model, TotalMemoryGB, CPU, CPUSockets, CPUCores, HyperVState)
                      VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $stmtInsertHost = $conn->prepare($sqlInsertHost);
    $stmtInsertHost->bind_param("sssssdiiis", $hostName, $os, $osVersion, $manufacturer, $model, $totalMemoryGB, $cpuSockets, $cpuCores, $cpu, $hyperVState);
    $stmtInsertHost->execute();
    $hostID = $stmtInsertHost->insert_id;  // Get the inserted HostID
    $stmtInsertHost->close();
}

$stmtCheckHost->close();

// For each VM, check if it exists, update if it does, or insert if it doesn't
$sqlCheckVM = "SELECT VMID FROM VMDetails WHERE HostID = ? AND VMName = ?";
$stmtCheckVM = $conn->prepare($sqlCheckVM);

$sqlUpdateVM = "UPDATE VMDetails SET Status = ?, CPUUsage = ?, MemoryAssignedMB = ?, Uptime = ?, HostName = ?, Generation = ? WHERE VMID = ?";
$stmtUpdateVM = $conn->prepare($sqlUpdateVM);

$sqlInsertVM = "INSERT INTO VMDetails (HostID, VMName, Status, CPUUsage, MemoryAssignedMB, Uptime, Generation, HostName)
                VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
$stmtInsertVM = $conn->prepare($sqlInsertVM);

foreach ($vmDetails as $vm) {
    $vmName = $vm['VMName'];
    $status = $vm['Status'];
    $cpuUsage = $vm['CPUUsage'];
    $memoryAssignedMB = $vm['MemoryAssigned'];
    $uptime = $vm['Uptime'];
    $generation = $vm['Generation'];
    $hostName = $vm['HostName'];

    // Check if VM exists for this host
    $stmtCheckVM->bind_param("is", $hostID, $vmName);
    $stmtCheckVM->execute();
    $stmtCheckVM->store_result();

    if ($stmtCheckVM->num_rows > 0) {
        // VM exists, update it
        $stmtCheckVM->bind_result($vmID);
        $stmtCheckVM->fetch();

        $stmtUpdateVM->bind_param("siiisii", $status, $cpuUsage, $memoryAssignedMB, $uptime, $hostName, $generation, $vmID);
        $stmtUpdateVM->execute();
    } else {
        // VM does not exist, insert a new one
        $stmtInsertVM->bind_param("issiiiss", $hostID, $vmName, $status, $cpuUsage, $memoryAssignedMB, $uptime, $generation, $hostName);
        $stmtInsertVM->execute();
    }
}


// Close statements
$stmtCheckVM->close();
$stmtUpdateVM->close();
$stmtInsertVM->close();

// Close the connection
$conn->close();

// Success message
echo "Host and VM details saved/updated successfully!";
?>
