<?php
// Get the JSON payload
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// Include the database configuration file
require 'dbconfig.php';


try {
    // Create a new PDO instance
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Get the JSON input
    $input = json_decode(file_get_contents('php://input'), true);

    // Prepare SQL statement for inserting or updating computer details
    $stmt = $pdo->prepare("
        INSERT INTO computer_details (ComputerName, Manufacturer, Model, CPUModel, OSVersion, OperatingSystem, RegisteredUser, RAM, PublicIP, SerialNumber, logged_in_user, Domain, admin_group_members, rdp_group_members, IP_Address, System_Type, Build_Number, Service_Pack, Product_ID, ServiceTag, BiosManufacturer, BiosVersion, SMBiosVersion, BiosDate, CPUSockets, CPUCoreCount, LogicalProcessorCount, MachineRunningState, LastRunTime) 
        VALUES (:ComputerName, :Manufacturer, :Model, :CPUModel, :OSVersion, :OperatingSystem, :RegisteredUser, :RAM, :PublicIP, :SerialNumber, :logged_in_user, :Domain, :admin_group_members, :rdp_group_members, :IP_Address, :System_Type, :Build_Number, :Service_Pack, :Product_ID, :ServiceTag, :BiosManufacturer, :BiosVersion, :SMBiosVersion, :BiosDate, :CPUSockets, :CPUCoreCount, :LogicalProcessorCount, :MachineRunningState, :LastRunTime)
        ON DUPLICATE KEY UPDATE 
            Manufacturer = :Manufacturer, 
            Model = :Model, 
            CPUModel = :CPUModel, 
            OSVersion = :OSVersion,
            OperatingSystem = :OperatingSystem,
            RegisteredUser = :RegisteredUser,
            RAM = :RAM, 
            PublicIP = :PublicIP, 
            SerialNumber = :SerialNumber, 
            logged_in_user = :logged_in_user, 
            Domain = :Domain, 
            admin_group_members = :admin_group_members, 
            rdp_group_members = :rdp_group_members,
            IP_Address = :IP_Address,
            System_Type = :System_Type,
            Build_Number = :Build_Number,
            Service_Pack = :Service_Pack,
            Product_ID = :Product_ID,
            ServiceTag = :ServiceTag,
            BiosManufacturer = :BiosManufacturer,
            BiosVersion = :BiosVersion,
            SMBiosVersion = :SMBiosVersion,
            BiosDate = :BiosDate,
            CPUSockets = :CPUSockets,
            CPUCoreCount = :CPUCoreCount,
            LogicalProcessorCount = :LogicalProcessorCount,
            MachineRunningState = :MachineRunningState,
            LastRunTime = :LastRunTime
    ");

    // Bind parameters
    $stmt->bindParam(':ComputerName', $input['ComputerName']);
    $stmt->bindParam(':Manufacturer', $input['Manufacturer']);
    $stmt->bindParam(':Model', $input['Model']);
    $stmt->bindParam(':CPUModel', $input['CPUModel']);
    $stmt->bindParam(':OSVersion', $input['OSVersion']);
    $stmt->bindParam(':OperatingSystem', $input['OperatingSystem']);
    $stmt->bindParam(':RegisteredUser', $input['RegisteredUser']);
    $stmt->bindParam(':RAM', $input['RAM']);
    $stmt->bindParam(':PublicIP', $input['PublicIP']);
    $stmt->bindParam(':SerialNumber', $input['SerialNumber']);
    $stmt->bindParam(':logged_in_user', $input['logged_in_user']);
    $stmt->bindParam(':Domain', $input['domain']);
    $stmt->bindParam(':admin_group_members', $input['admin_group_members']);
    $stmt->bindParam(':rdp_group_members', $input['rdp_group_members']);
    $stmt->bindParam(':IP_Address', $input['IP_Address']);
    $stmt->bindParam(':System_Type', $input['System_Type']);
    $stmt->bindParam(':Build_Number', $input['Build_Number']);
    $stmt->bindParam(':Service_Pack', $input['Service_Pack']);
    $stmt->bindParam(':Product_ID', $input['Product_ID']);
    $stmt->bindParam(':ServiceTag', $input['ServiceTag']);
    $stmt->bindParam(':BiosManufacturer', $input['BiosManufacturer']);
    $stmt->bindParam(':BiosVersion', $input['BiosVersion']);
    $stmt->bindParam(':SMBiosVersion', $input['SMBiosVersion']);
    $stmt->bindParam(':BiosDate', $input['BiosDate']);
    $stmt->bindParam(':CPUSockets', $input['CPUSockets']);
    $stmt->bindParam(':CPUCoreCount', $input['CPUCoreCount']);
    $stmt->bindParam(':LogicalProcessorCount', $input['LogicalProcessorCount']);
    $stmt->bindParam(':MachineRunningState', $input['MachineRunningState']);
    $stmt->bindParam(':LastRunTime', $input['LastRunTime']);

    // Execute the statement
    if ($stmt->execute()) {
        echo json_encode(['Data saved or updated successfully']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to save data']);
    }
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
