<?php
// Include the database configuration file
require 'dbconfig.php';

try {
    // Create connection
    $conn = new mysqli($servername, $username, $password, $dbname);

    // Check connection
    if ($conn->connect_error) {
        throw new Exception("Connection failed: " . $conn->connect_error);
    }

    // Get the JSON input from the POST request
    $jsonInput = file_get_contents('php://input');

    // Decode the JSON data into a PHP array
    $data = json_decode($jsonInput, true);

    // Validate input data
    $requiredFields = ['ComputerName', 'ip_address', 'city', 'region', 'country_code', 'country_name', 'location', 'isp'];
    foreach ($requiredFields as $field) {
        if (!isset($data[$field]) || empty($data[$field])) {
            throw new Exception("Invalid input: Missing or empty field '$field'.");
        }
    }

    // Extract and sanitize inputs
    $computerName = $conn->real_escape_string($data['ComputerName']);
    $ipAddress = $conn->real_escape_string($data['ip_address']);
    $city = $conn->real_escape_string($data['city']);
    $region = $conn->real_escape_string($data['region']);
    $countryCode = $conn->real_escape_string($data['country_code']);
    $countryName = $conn->real_escape_string($data['country_name']);
    $location = $conn->real_escape_string($data['location']);
    $isp = $conn->real_escape_string($data['isp']);

    // Prepare a query to check if the record exists
    $stmt = $conn->prepare("SELECT COUNT(*) FROM geo_details WHERE ComputerName = ? AND ip_address = ?");
    $stmt->bind_param("ss", $computerName, $ipAddress);
    $stmt->execute();
    $stmt->bind_result($recordCount);
    $stmt->fetch();
    $stmt->close();

    if ($recordCount > 0) {
        // If the record exists, prepare an update statement
        $stmt = $conn->prepare(
            "UPDATE geo_details SET 
            city = ?, 
            region = ?, 
            country_code = ?, 
            country_name = ?, 
            location = ?, 
            isp = ?, 
            updated_at = NOW()
            WHERE ComputerName = ? AND ip_address = ?"
        );

        $stmt->bind_param(
            "ssssssss",
            $city,
            $region,
            $countryCode,
            $countryName,
            $location,
            $isp,
            $computerName,
            $ipAddress
        );

        // Execute the update statement
        if ($stmt->execute()) {
            echo json_encode(["Geolocation details updated successfully."]);
        } else {
            throw new Exception("Error during update: " . $stmt->error);
        }
    } else {
        // If the record does not exist, prepare an insert statement
        $stmt = $conn->prepare(
            "INSERT INTO geo_details (ComputerName, ip_address, city, region, country_code, country_name, location, isp, created_at) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW())"
        );

        $stmt->bind_param(
            "ssssssss",
            $computerName,
            $ipAddress,
            $city,
            $region,
            $countryCode,
            $countryName,
            $location,
            $isp
        );

        // Execute the insert statement
        if ($stmt->execute()) {
            echo json_encode(["Geolocation details saved successfully."]);
        } else {
            throw new Exception("Error during insert: " . $stmt->error);
        }
    }

    // Close the statement and connection
    $stmt->close();
    $conn->close();
} catch (Exception $e) {
    // Log error details for debugging (optional, but recommended)
    error_log("Error: " . $e->getMessage());

    // Return error message as JSON response
    echo json_encode(["error" => $e->getMessage()]);
}
?>
