<?php
// Get the JSON payload
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// Include the database configuration file
require 'dbconfig.php';

try {
    // Create a new PDO instance
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Get the JSON input
    $input = json_decode(file_get_contents('php://input'), true);

    // Check if the input is valid
    if (isset($input['NetworkAdapters']) && is_array($input['NetworkAdapters'])) {
        // Prepare SQL statement to check for existing records
        $checkStmt = $pdo->prepare("
            SELECT COUNT(*) FROM network_details 
            WHERE ComputerName = :ComputerName AND MACAddress = :MACAddress
        ");

        // Prepare SQL statement to insert or update network details
        $updateStmt = $pdo->prepare("
            UPDATE network_details 
            SET 
                NICName = :NICName, 
                IPAddress = :IPAddress,
                DHCPEnabled = :DHCPEnabled,
                DHCPServer = :DHCPServer,
                ConnectionStatus = :ConnectionStatus,
                DNSServers = :DNSServers,
                LastRunTime = :LastRunTime
            WHERE ComputerName = :ComputerName AND MACAddress = :MACAddress
        ");

        $insertStmt = $pdo->prepare("
            INSERT INTO network_details (ComputerName, NICName, MACAddress, IPAddress, DHCPEnabled, DHCPServer, ConnectionStatus, DNSServers, LastRunTime) 
            VALUES (:ComputerName, :NICName, :MACAddress, :IPAddress, :DHCPEnabled, :DHCPServer, :ConnectionStatus, :DNSServers, :LastRunTime)
        ");

        foreach ($input['NetworkAdapters'] as $adapter) {
            // Bind parameters for the check statement
            $checkStmt->bindParam(':ComputerName', $input['ComputerName']);
            $checkStmt->bindParam(':MACAddress', $adapter['MACAddress']);

            // Execute the check statement
            $checkStmt->execute();
            $exists = $checkStmt->fetchColumn();

            // Convert DHCPEnabled to boolean
            $dhcpEnabled = filter_var($adapter['DHCPEnabled'], FILTER_VALIDATE_BOOLEAN);

            if ($exists) {
                // If the record exists, update it
                $updateStmt->bindParam(':ComputerName', $input['ComputerName']);
                $updateStmt->bindParam(':NICName', $adapter['NICName']);
                $updateStmt->bindParam(':MACAddress', $adapter['MACAddress']);
                $updateStmt->bindParam(':IPAddress', $adapter['IPAddress']);
                $updateStmt->bindParam(':DHCPEnabled', $dhcpEnabled, PDO::PARAM_BOOL);
                $updateStmt->bindParam(':DHCPServer', $adapter['DHCPServer']);
                $updateStmt->bindParam(':ConnectionStatus', $adapter['ConnectionStatus']);
                $updateStmt->bindParam(':DNSServers', $adapter['DNSServers']);
                $updateStmt->bindParam(':LastRunTime', $input['LastRunTime']);

                // Execute the update statement
                $updateStmt->execute();
            } else {
                // If the record does not exist, insert a new one
                $insertStmt->bindParam(':ComputerName', $input['ComputerName']);
                $insertStmt->bindParam(':NICName', $adapter['NICName']);
                $insertStmt->bindParam(':MACAddress', $adapter['MACAddress']);
                $insertStmt->bindParam(':IPAddress', $adapter['IPAddress']);
                $insertStmt->bindParam(':DHCPEnabled', $dhcpEnabled, PDO::PARAM_BOOL);
                $insertStmt->bindParam(':DHCPServer', $adapter['DHCPServer']);
                $insertStmt->bindParam(':ConnectionStatus', $adapter['ConnectionStatus']);
                $insertStmt->bindParam(':DNSServers', $adapter['DNSServers']);
                $insertStmt->bindParam(':LastRunTime', $input['LastRunTime']);

                // Execute the insert statement
                $insertStmt->execute();
            }
        }

        echo json_encode(['Network details updated successfully']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Invalid input']);
    }
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
