<?php
// Get the JSON payload
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// Include the database configuration file
require 'dbconfig.php';



try {
    // Create a new PDO instance
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Get the JSON input
    $input = json_decode(file_get_contents('php://input'), true);

    // Check for missing fields
    if (empty($input['ComputerName']) || empty($input['PatchID'])) {
        echo json_encode(['success' => false, 'message' => 'ComputerName and PatchID are required']);
        exit;
    }

    // Prepare SQL statement to insert/update patch details
    $stmt = $pdo->prepare("
        INSERT INTO patch_details (ComputerName, PatchID, Description, InstalledOn) 
        VALUES (:ComputerName, :PatchID, :Description, :InstalledOn)
        ON DUPLICATE KEY UPDATE 
            Description = :Description, 
            InstalledOn = :InstalledOn
    ");

    // Bind parameters
    $stmt->bindParam(':ComputerName', $input['ComputerName']);
    $stmt->bindParam(':PatchID', $input['PatchID']);
    $stmt->bindParam(':Description', $input['Description']);
    $stmt->bindParam(':InstalledOn', $input['InstalledOn']);

    // Execute the statement
    $stmt->execute();

    echo json_encode(['Last Patch details updated successfully']);
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
