<?php
// Include the database configuration file
require 'dbconfig.php';

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check the connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get the JSON input from the POST request
$jsonInput = file_get_contents('php://input');

// Decode the JSON data into a PHP array
$data = json_decode($jsonInput, true);

// Prepare a query to check if the record exists
$stmt = $conn->prepare("SELECT COUNT(*) FROM vm_details WHERE computer_name = ? AND vm_name = ?");
$stmt->bind_param("ss", $data['ComputerName'], $data['VMName']);
$stmt->execute();
$stmt->bind_result($recordCount);
$stmt->fetch();
$stmt->close();

if ($recordCount > 0) {
    // If the record exists, prepare an update statement
    $stmt = $conn->prepare("UPDATE vm_details SET 
        state = ?, 
        cpu_count = ?, 
        assigned_memory_mb = ?, 
        uptime = ?, 
        status = ?, 
        virtual_switch = ?, 
        version = ? 
        WHERE computer_name = ? AND vm_name = ?");

    $stmt->bind_param("siissssss", 
        $data['State'], 
        $data['CPUCount'], 
        $data['AssignedMemoryMB'], 
        $data['Uptime'], 
        $data['Status'], 
        $data['VirtualSwitch'], 
        $data['Version'],
        $data['ComputerName'], 
        $data['VMName']
    );

    // Execute the update statement
    if ($stmt->execute()) {
        echo json_encode(["message" => "VM details updated successfully."]);
    } else {
        echo json_encode(["error" => "Error: " . $stmt->error]);
    }
} else {
    // If the record does not exist, prepare an insert statement
    $stmt = $conn->prepare("INSERT INTO vm_details (computer_name, vm_name, state, cpu_count, assigned_memory_mb, uptime, status, virtual_switch, version) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("sssiissss", 
        $data['ComputerName'], 
        $data['VMName'], 
        $data['State'], 
        $data['CPUCount'], 
        $data['AssignedMemoryMB'], 
        $data['Uptime'], 
        $data['Status'], 
        $data['VirtualSwitch'], 
        $data['Version']
    );

    // Execute the insert statement
    if ($stmt->execute()) {
        echo json_encode(["message" => "VM details saved successfully."]);
    } else {
        echo json_encode(["error" => "Error: " . $stmt->error]);
    }
}

// Close the statement and connection
$stmt->close();
$conn->close();
?>
